import React, { useState } from 'react';

const COCform = () => {
  const [formData, setFormData] = useState({
    full_name: '',
    company_name: '',
    email_address: '',
    phone_num: '',
    concern: '',
    vertical: "DEL",
    ip: '',
    attachment: null,
  });

  const [successMessage, setSuccessMessage] = useState('');
  const [errorMessage, setErrorMessage] = useState('');

  const handleChange = (event) => {
    const { name, value } = event.target;
    setFormData({
      ...formData,
      [name]: value,
    });
  };

  const handleImageChange = (event) => {
    const file = event.target.files[0];
    if (file.size <= 20 * 1024 * 1024) {
      setFormData({
        ...formData,
        attachment: file,
      });
    } else {
      // Display an error message or handle the large image in some way.
      console.error('Image size exceeds 20MB limit');
    }
  };

  const handleSubmit = async () => {
    // Validate the form fields before submission
    if (
      !formData.full_name ||
      !formData.company_name ||
      !formData.email_address ||
      !formData.phone_num ||
      !formData.concern
    ) {
      setErrorMessage('Please fill all required fields.');
      return;
    }

    // Convert form data to FormData object
    const data = new FormData();
    for (const key in formData) {
      if (key !== 'attachment' || (key === 'attachment' && formData[key])) {
        data.append(key, formData[key]);
      }
    }

    // API endpoint URL
    const apiUrl = 'https://www.descon.com/en/rest-api/coc/create.php';

    try {
      // Send form data using fetch API
      const response = await fetch(apiUrl, {
        method: 'POST',
        body: data,
      });

      if (response.ok) {
        // Form submitted successfully
        console.log('Form submitted successfully');
        setSuccessMessage(
          'Form submitted successfully! Our team will revert upon receiving.'
        );
        setErrorMessage('');
        // Reset the form after successful submission
        setFormData({
          full_name: '',
          company_name: '',
          email_address: '',
          phone_num: '',
          concern: '',
          vertical: "DEL",
          ip: '',
          attachment: null,
        });
      } else {
        // Handle form submission error
        console.error('Form submission failed');
      }
    } catch (error) {
      // Handle other errors, e.g., network issues
      console.error('Error occurred:', error);
    }
  };

  return (
    <div className='contact'>
      <div className='container'>
        <div className='row'>
          <div className='col-lg-6 col-12 col-md-12 mt-4 mb-5 WBFORM'>
            <h1 className='fw-bold text-dark'>Submit your complaint</h1>
            <p className='text-muted mt-3'>Our team will revert upon receiving.</p>
            <div className='row mt-5'>
              <div className='col-12 mb-4'>
                <label htmlFor='full_name' className='form-label' required>
                  Full Name *
                </label>
                {/* <input
                  type='text'
                  className='form-control form-control-lg'
                  name='full_name'
                  value={formData.full_name}
                  onChange={handleChange}
                /> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='company_name' className='form-label' required>
                  Company/Vendor Name *
                </label>
                {/* <input
                  type='text'
                  className='form-control form-control-lg'
                  name='company_name'
                  value={formData.company_name}
                  onChange={handleChange}
                /> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='phone_num' className='form-label' required>
                  Phone Number *
                </label>
                {/* <input
                  type='text'
                  className='form-control form-control-lg'
                  name='phone_num'
                  value={formData.phone_num}
                  onChange={handleChange}
                /> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='email_address' className='form-label' required>
                  Email Address *
                </label>
                {/* <input
                  type='email'
                  className='form-control form-control-lg'
                  name='email_address'
                  value={formData.email_address}
                  onChange={handleChange}
                /> */}
              </div>

              {/* <input type="hidden"
                name="division"
                value={formData.vertical}
                onChange={handleChange}
              /> */}

              <div className='col-12 mb-4'>
                <label htmlFor='concern' className='form-label' required>
                  Concern *
                </label>
                {/* <textarea rows="6"
                  className='form-control form-control-lg'
                  placeholder='Write your concern here'
                  name='concern'
                  value={formData.concern}
                  onChange={handleChange}
                ></textarea> */}
              </div>
              <div className='col-12 mb-4'>
                <label htmlFor='formFile' className='form-label' >
                  Evidence <span className='text-end'>(Max file size 20mb)</span>
                </label>
                {/* <input className='form-control' type='file' id='formFile' name='attachment' onChange={handleImageChange} /> */}
              </div>
              <div className='d-grid gap-2'>
                {/* <button className='btn btn-primary' type='button' onClick={handleSubmit}>
                  Send Message
                </button> */}
                <a className='btn btn-primary' type='button' href='mailto:info@descon.com?&subject=codeofconduct - DEL'>
                  Composed Mail
                </a>
              </div>
              {errorMessage && <div className='alert alert-danger mt-4'>{errorMessage}</div>}
              {successMessage && <div className='alert alert-success mt-4'>{successMessage}</div>}
            </div>
          </div>
          <div className='col-lg-5 col-12 col-md-12 mt-4  mb-5  WB'>
            <h1 className='fw-bold text-dark'>DEFINITIONS</h1>
            <h3>Bribery</h3>
            <p>
              A bribe is defined as an amount of money or any favor given or promised in order to influence the judgment
              or conduct of a person in a position of trust. A bribe may also take the form of gifts, travel expenses,
              below market loans, favors, and business/ employment opportunities etc.
            </p>
            <h3>Prohibited/ Facilitation payments</h3>
            <p>Offering or giving of improper benefits or making payments, in order to influence the decision of the recipient.</p>
            <h3>Conflict of interest</h3>
            <p>
              A conflict of interest may exist when an employee or a member of his or her family is involved in an activity
              or has a personal interest that could impair, or even appear to impair, the ability to make objective and fair
              decisions or could create an incentive to act in a manner that would advance personal interests at the expense of Descon.
            </p>
          </div>
        </div>
      </div>
    </div>
  );
};

export default COCform;

